/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.NetworkNodeParameter;
import java.io.IOException;

public class AnalogNetworkNodeParameter
extends NetworkNodeParameter {
    private static final long serialVersionUID = -5635055583208302255L;

    public AnalogNetworkNodeParameter() {
    }

    public AnalogNetworkNodeParameter(Block block) {
        super(block);
    }

    public double calculateAnalogValue() {
        if (this.fInterpreter == null) {
            return 0.0;
        }
        int vmAdd = this.isForSlave() ? this.getBlock().getHardware().getIntProperty("anStartAddress") + (this.getBlock().getNumber() - 1) / 8 * 2 : this.getVMAddress();
        return this.fInterpreter.readVM(2, vmAdd);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.setForSlave(dr.readBoolean());
        if (this.isForSlave()) {
            this.setAddress(dr.readString());
            this.setConfiguredBlockType(dr.readInt());
            this.setConfiguredBlockNumber(dr.readInt());
        } else {
            this.setVMAddress(dr.readInt());
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        if (this.isForSlave()) {
            dw.writeBoolean(true);
            dw.writeString(this.getAddress());
            dw.writeInt(this.getConfiguredBlockType());
            dw.writeInt(this.getConfiguredBlockNumber());
        } else {
            dw.writeBoolean(false);
            dw.writeInt(this.getVMAddress());
        }
    }

    public String getBlockAbbreviation(int numberType) {
        if (11 == numberType) {
            return "AI";
        }
        if (13 == numberType) {
            return "AQ";
        }
        if (16 == numberType) {
            return "AM";
        }
        return "";
    }

    public String getAddressText() {
        return "VW: " + this.getVMAddress();
    }
}

